#version 120


////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////


uniform sampler2D texture;
uniform sampler2D lightmap;
uniform float rainStrength;


varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;






void main() {	

	
	vec2 adjustedTexCoord = texcoord.st;

	gl_FragData[0] = texture2D(texture, texcoord.st) * (color);
	gl_FragData[1] = vec4(gl_FragCoord.z,gl_FragCoord.z,gl_FragCoord.z, 1.0f);
	
	
	gl_FragData[4] = vec4(0.0, 0.0f, 1.0f, 0.0f);
	
	
	vec4 lightmap = texture2D(lightmap, lmcoord.st);
	
	
	gl_FragData[5] = lightmap;
	
	
	

	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}
}